<!-- 
"This sample program is provided AS IS and may be used, executed, copied and modified without
royalty payment by customer (a) for its own instruction and study, (b) in order to develop 
applications designed to run with an IBM WebSphere product, either for customer's own 
internal use or for redistribution by customer, as part of such an application, in customer's own products."

Product 5655-FLW,  (C) COPYRIGHT International Business Machines Corp., 2005
All Rights Reserved * Licensed Materials - Property of IBM
-->
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<%@ page language="java" contentType="text/html; charset=ISO-8859-1" pageEncoding="ISO-8859-1"%>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
<title>To-do Task Sample</title>
</head>
<body>
<div align = center>
<h1>To-do Task Sample</h1>
<br>

<%@ page import="com.ibm.task.api.LocalHumanTaskManagerHome"%>
<%@ page import="com.ibm.task.api.LocalHumanTaskManager"%>
<%@ page import="com.ibm.task.api.*"%>
<%@ page import="commonj.sdo.*"%>
<%@ page import="javax.naming.Context"%>
<%@ page import="bpc.samples.StateTranslator"%>

<!-- BEGINN General Code Section -->
<%
		LocalHumanTaskManager taskManager = null;
		int numOfInstances = 0;
		String name = null;
		QueryResultSet instances = null;

		try {

			//Obtain the defaukt initial context
			Context context = new javax.naming.InitialContext();

			//Lookup the Local Home Interface
			LocalHumanTaskManagerHome taskHome =
			   (LocalHumanTaskManagerHome) context.lookup("java:comp/env/ejb/LocalHumanTaskManagerHome");
			System.out.println("Lookup...success");

			//Access the local interface
			taskManager = taskHome.create();
			System.out.println("Accessing local interface...success");

			String taskTemplateName = "RequestTask";
			String taskNamespace    = "http://ToDoTask/bpc/samples";
			
			//query task instances
            String whereClause = "TASK_TEMPL.NAME='" + taskTemplateName + "' AND TASK_TEMPL.NAMESPACE='" + taskNamespace + "'";
			instances = taskManager.query("DISTINCT TASK.TKIID", whereClause, null,null, null, null);

			numOfInstances = instances.size();
			System.out.println(numOfInstances + " instances found");
		}

		catch (Exception e) {
			e.printStackTrace();
			System.out.println(e.getClass());
		}

		if (numOfInstances > 0) {
			//print the table

			%>
<table align="center" border="1" style="border-style:solid;" cellspacing="0">
    <thead>
        <tr>
            <th width="150" align="center" valign="middle" style="padding:5px;">Task identifier</th>
            <th width="200" align="center" valign="middle" style="padding:5px;">Question</th>
            <th width="200" align="center" valign="middle" style="padding:5px;">Answer</th>
            <th width="80" align="center" valign="middle" style="padding:5px;">State</th>
        </tr>
    </thead>
    <tbody>
        <%
			try {

					instances.first();

					for (int i = 0; i < numOfInstances; i++) {
						TKIID temp = (TKIID) instances.getOID(1);
						Task task = taskManager.getTask(temp);
						name = task.getName();
						if (name.equals("")) {
							name = "&nbsp;";
						}
						String input  = "not available";
						String output = "not available";

						//get the input message of instance i.
                        try
                        {
                            ClientObjectWrapper req = taskManager.getInputMessage(temp);
                            DataObject inputDO = (DataObject) req.getObject();
                            if(inputDO != null)
                            {
                                input = inputDO.getString("question");
                                if(input == null || input.equals("")){
                                    input = "&npsp;";
                                }                         
                            }
                        }
                        catch(Exception e1)
                        {
                            System.out.println(e1);
                        }

						//get the output message of instance i, if possible
                        try
                        {
                            if (taskManager.getOutputMessage(temp).getObject() != null) {
                                //get the output message
                                ClientObjectWrapper resp = taskManager.getOutputMessage(temp);
                                DataObject outputDO = (DataObject) resp.getObject();
                                if(outputDO != null)
                                {
                                    output = outputDO.getString("answer");
                                    if (output == null || output.equals("")) {
                                        output = "&nbsp;";
                                    }
                                }
                            }
                        }
                        catch(Exception e2)
                        {
                            System.out.println(e2);
                        }

						//print table row for instance i
						out.print("<tr><td align=\"center\" style=\"padding:5px;\">"
										+ name
										+ "</td><td align=\"center\" style=\"padding:5px;\">"
										+ input
										+ "</td><td align=\"center\" style=\"padding:5px;\">"
										+ output
										+ "</td><td align=\"center\" style=\"padding:5px;\">"
										+ StateTranslator.translate(task.getState())
										+ "</td></tr>");

						instances.next();
					}
			}

			catch (Exception e)
			{
				e.printStackTrace();
				System.out.println(e.getClass());
				out.print("Exception occured. Check System.out.log for Details.");
			}

		%>
        <!-- END List Code Section -->
    </tbody>
</table>
<br>
<br>

<input type="button" value="  Home   " onclick="document.location.href='index.html'">
<input type="button" value="   New   " onclick="document.location.href='create.html'">
<input type="button" value="Delete all" onclick="document.location.href='clearAll.jsp'">
<input type="button" value="Delete finished" onclick="document.location.href='clearFinished.jsp'">
<input type="button" value="Refresh table" onclick="document.location.href='list.jsp'">
<br>
<%} else {
			//print return button

		%>
<p>No instances of type ProcessStarter found.</p>
<br>
<br>
<input type="button" value="  Home   " onclick="document.location.href='index.html'">
<input type="button" value="   New   " onclick="document.location.href='create.html'">
<%}%>
</div>
</body>
</html>
