//*****************************************************************************
//*                                                                           *
//* "This sample program is provided AS IS and may be used, executed, copied  *
//* and modified without royalty payment by customer                          *
//* (a) for its own instruction and study,                                    *
//* (b) in order to develop applications designed to run with an              *
//*     IBM WebSphere product, either for customer's own internal use or for  *
//*     redistribution by customer, as part of such an application, in        *
//*     customer's own products."                                             *
//*                                                                           *
//* Product 5655-FLW,                                                         *
//* (C) COPYRIGHT International Business Machines Corp., 2009                 *
//* All Rights Reserved * Licensed Materials - Property of IBM                *
//*                                                                           *
//*****************************************************************************
//*                                                                           *
//* DISCLAIMER                                                                *
//*                                                                           *
//* This material contains programming source code for your consideration.    *
//* These examples have not been thoroughly tested under all conditions.      *
//* IBM, therefore, cannot guarantee or imply reliability, serviceability,    *
//* or function of these programs.                                            *
//* ALL PROGRAMS CONTAINED HEREIN ARE PROVIDED TO YOU "AS IS", WITHOUT ANY    *
//* WARRANTIES (EXPRESS OR IMPLIED) OR SUPPORT WHATSOEVER, INCLUDING BUT      *
//* NOT LIMITED TO ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS       *
//* FOR A PARTICULAR PURPOSE.                                                 *
//*                                                                           *
//*****************************************************************************

import java.io.IOException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ibm.bpe.api.AdminAuthorizationOptions;
import com.ibm.bpe.api.BusinessFlowManagerHome;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.api.EntityResultSet;
import com.ibm.bpe.api.FilterOptions;

public class QueryServlet extends HttpServlet implements Servlet {

	private static final long serialVersionUID = 1L;

	public QueryServlet() {
	}

	public void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		doPost(req, resp);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse resp)
			throws ServletException, IOException {
		
		String queryTable     = request.getParameter("selection");
		String selAttributes  = request.getParameter("attributes");
		String queryCondition = request.getParameter("condition");
		String other          = request.getParameter("other");
		if (queryTable!=null && queryTable.equals("[OTHER]")) {
			// special case, use parameter "other" instead
			queryTable = other;
		}
		
		request.setAttribute("queryTable", queryTable);

		if (queryTable != null) {
			try {
				BusinessFlowManagerService bfmService = getBFMService();
				FilterOptions filterOpts = new FilterOptions();
				filterOpts.setLocale(request.getLocale());
				filterOpts.setThreshold(new Integer(20));
				if (selAttributes!=null) {
					filterOpts.setSelectedAttributes(selAttributes.trim());
				}
				if (queryCondition!=null) {
					filterOpts.setQueryCondition(queryCondition.trim());
				}
				AdminAuthorizationOptions authOpts = null;
				if (bfmService.isBusinessProcessAdministrator()) {
					// grant privileges to look at query tables containing template data:
					authOpts = new AdminAuthorizationOptions();
				} 
				EntityResultSet ers = bfmService.queryEntities(queryTable, filterOpts, authOpts, null);
				request.setAttribute("result", ers);
			} catch (Exception e) {
				e.printStackTrace(System.out);
				request.setAttribute("exception", e.getMessage());
			}
		} else {
			// no query table selected for query
		}
		
		
		String nextJSP = "index.jsp";
		RequestDispatcher dispatcher = getServletContext().getRequestDispatcher(nextJSP);
		dispatcher.forward(request, resp);

	}
	
	private BusinessFlowManagerService getBFMService() {
		try {
			Context ctx = new InitialContext();
			Object obj = ctx.lookup("java:comp/env/ejb/BFM");
			BusinessFlowManagerHome bfmHome = (BusinessFlowManagerHome) PortableRemoteObject.narrow(obj, BusinessFlowManagerHome.class);
			BusinessFlowManagerService bfmService = bfmHome.create();
			return bfmService;
		} catch (Exception e) {
			throw new RuntimeException("Could not find the business flow manager service EJB.", e);
		}
	}
		
}
