package com.ibm.clipsandtacks.sample;

import com.ibm.websphere.fabric.da.PendingRequest;
import com.ibm.websphere.fabric.da.context.Context;
import com.ibm.websphere.fabric.da.plugin.ContextExtractor;
import com.ibm.websphere.fabric.da.plugin.UnexpectedContentException;
import com.ibm.websphere.fabric.da.types.TypedValue;
import com.ibm.websphere.sca.ServiceManager;
import com.ibm.ws.fabric.da.sca.util.SdoUtil;

import commonj.sdo.DataObject;

public class ContextExtractorImpl implements ContextExtractor {
	
	private static final String TOTALPRICE_URI = "http://www.ibm.com/websphere/fabric/banking/payments/iso20022/ext/assertions#totalPrice";
	private static final String COUNTRY_URI = "http://www.ibm.com/websphere/fabric/banking/payments/iso20022/ext/assertions#country";
	private static final String POSTALCODE_URI = "http://www.ibm.com/websphere/fabric/banking/payments/iso20022/ext/assertions#postalCode";
	
	/**
	 * Default constructor.
	 */
	public ContextExtractorImpl() {
		super();
	}

	/**
	 * Return a reference to the component service instance for this implementation
	 * class.  This method should be used when passing this service to a partner reference
	 * or if you want to invoke this component service asynchronously.    
	 *
	 * @generated (com.ibm.wbit.java)
	 */
	@SuppressWarnings("unused")
	private ContextExtractor getMyService() {
		return (ContextExtractor) ServiceManager.INSTANCE.locateService("self");
	}

	/* (non-Javadoc)
	 * @see com.ibm.websphere.fabric.da.plugin.ContextExtractor#extractContext(PendingRequest arg0) 
	 */
	public Context extractContext(PendingRequest request)
			throws UnexpectedContentException {
		DataObject body = request.getMessageBody();
		
		System.out.println("+++++++++++++++INSIDE CALCULATE SHIPPING CHARGES CONTENT EXTRACTOR++++++++");
		
		// use this util method to print out the entire SDO tree
		// System.out.println(SdoUtil.printTree(creditRequest));
		
		DataObject orderRequest = ((DataObject)body.getSequence(0).getValue(0));
		
//		System.out.println("******************************************first orderRequest");
//		System.out.println(SdoUtil.printTree(orderRequest));
		
		// Necessary to get the correct XPATH
		orderRequest = ((DataObject) orderRequest.getSequence(0).getValue(0));

//		System.out.println("******************************************second orderRequest");
		System.out.println(SdoUtil.printTree(orderRequest));
		
			Double totalPrice = (Double) orderRequest.get("TotalPrice");
			String country = (String) orderRequest.get("Customer/Country");
			String postalCode = (String) orderRequest.get("Customer/PostalCode");
		
			System.out.println("TotalPrice is " + totalPrice);
			System.out.println("Country is " + country);
			System.out.println("PostalCode is " + postalCode);
			
			Context context = request.getContext();		
			context.setSelectionProperty(TOTALPRICE_URI, new TypedValue(totalPrice.toString()));
			context.setSelectionProperty(COUNTRY_URI, new TypedValue(country));
			context.setSelectionProperty(POSTALCODE_URI, new TypedValue(postalCode));

			System.out.println(context);
			System.out.println("+++++++++++++++EXITING CALCULATE SHIPPING CHARGES CONTENT EXTRACTOR++++++++");
		
		return context;
	}

}