/*
 * DISCLAIMER:
 * The following [enclosed] code is sample code created by IBM Coporation,
 * International Technical Support Organization (ITSO).
 * This sample code is not part of any standard IBM product
 * and is provided to you solely for the purpose of assisting you in the
 * development of your applications. The code is provided 'AS IS',
 * without warranty of any kind IBM shall not be liable for any damages
 * arising out of your use of sample code, even if they have been
 * advised of the possibility of such damages.
 * 
 * Author: Ueli Wahli
 */ 
package com.clipstacks.credit;

import com.ibm.websphere.bo.BOCopy;
import com.ibm.websphere.bo.BOFactory;
import com.ibm.websphere.sca.Service;
import com.ibm.websphere.sca.ServiceManager;

import commonj.sdo.DataObject;

// This bean is used in the business process "Check Customer Account Status" activity
// to calculate a new "rating" and "availableCredit" for a customer.
// step 1:  get a new "rating"
// step 2:  calculate new "availableCredit" using old and new rating and an adjustment factor:
//          availCredit = availCredit + (newRating - oldRating) * creditAdjustmentFactor
// This bean has a switch: useWebservice = true or false
// it can call the CreditService Web Service or calculate the rating itself 
// (this enables testing without having to install the Web Service)

public class CreditRating {
	
	static double creditAdjustmentFactor = 0.1;  // how much to adjust the credit limit
	
	static boolean useWebservice = false; // set to true to use the Web Service
										  // must be careful about host/port configuration
	String namespace = "http://creditservice.com";
// ADS	String namespaceBO = "http://www.ibm.com/clips";
	String namespaceBO = "http://ClipsAndTacksF1/ClipsAndTacks/Order";

	public DataObject calculateCreditRating(DataObject orderIn) {
		
		int newRating = 0;					// to be calculated

		DataObject customerIn     = orderIn.getDataObject("Customer");
		
		int        customerNumber = customerIn.getInt("CustomerNumber");
		String     companyName    = customerIn.getString("CompanyName");
		int        oldRating      = customerIn.getInt("Rating");
		double     availCredit    = customerIn.getDouble("AvailableCredit");
		
		System.out.println("Rating/Credit before for customer #: " + customerNumber + ": " + 
							oldRating + "/" + availCredit + " => " + (oldRating / availCredit));
		
		// Create helper objects
		ServiceManager serviceManager = new ServiceManager();
		BOFactory boFactory     = (BOFactory)serviceManager.locateService("com/ibm/websphere/bo/BOFactory");
		BOCopy    boCopyService = (BOCopy)serviceManager.locateService("com/ibm/websphere/bo/BOCopy");
	
		if (useWebservice) {
			try {
				// retrieve Credit Service (import)
				Service creditService = (Service)serviceManager.locateService("CreditBeanPartner");
				
				// create data objects for Web Service call
				DataObject wsInput      = boFactory.createByElement(namespace,"checkCredit");
				DataObject customerBean = boFactory.create(namespace, "CustomerBean");
				customerBean.setInt("customerNumber", customerNumber);
				customerBean.setString("companyName", companyName);
				wsInput.setDataObject("customer", customerBean);
				
				// invoke Web Service
				System.out.println("...invoking checkCredit Web Service ...");		
				DataObject wsResult = (DataObject)creditService.invoke("checkCredit", wsInput);
				
				// retrieve result from Web Service result
				newRating = wsResult.getInt("checkCreditReturn");
			} catch (Exception e) {
				System.out.println("...Web Service call failed: "+e.getMessage());
				useWebservice = false;	// simulate from now on
			}
		}
		if (!useWebservice) {
			// simulation without Web Service
			newRating = 650 + (new java.util.Random()).nextInt()%150;
			System.out.println("...simulate rating for customer #" + customerNumber + "  from company " + companyName + " ==> rating: " + newRating);
		}
		
		// calculate customer "Available Credit" from new credit rating
		// the new rating is used to adjust the credit up or down
		availCredit = availCredit + (newRating - oldRating) * creditAdjustmentFactor;
		System.out.println("...available credit for customer #" + customerNumber + "  from company " + companyName + " is " + availCredit);

		// copy the input order BO for returning
		DataObject orderOut    = boFactory.create(namespaceBO, "Order");
		orderOut = boCopyService.copy(orderIn);

		// copy of customer BO not required, copy of order BO creates new customer BO
		//DataObject customerOut = boFactory.create("http://Businessitems", "CustomerRecord");
		//customerOut = boCopyService.copy(customerIn);
		//orderOut.setDataObject("Customer", customerOut);
		
		// update the customer BO in the output BO
		DataObject customerOut = orderOut.getDataObject("Customer");
		customerOut.setInt("Rating", newRating);
		customerOut.setDouble("AvailableCredit", availCredit);
		System.out.println("Rating/Credit after for customer #: " + customerNumber + " is " + newRating + "/" + 
							availCredit + " * (" + creditAdjustmentFactor + ") => " + ((newRating / availCredit) * creditAdjustmentFactor));

		// update the customer in the database
		// deferred to human task JSPs

		// return the new order BO
		return orderOut;	
	}
}
