package processes.orderhandling;

import commonj.sdo.DataObject;
import com.ibm.websphere.sca.ServiceManager;
import java.math.BigDecimal;
import java.util.List;

public class CancelOrderandSendNotificationImpl {
	/**
	 * Default constructor.
	 */
	private com.ibm.websphere.sca.ServiceManager serviceManager = null;
	private com.ibm.websphere.bo.BOFactory boFactory = null;
	String namespace = "http://ClipsAndTacksF1/Businessitems";
	public CancelOrderandSendNotificationImpl() {
		super();
		serviceManager = new com.ibm.websphere.sca.ServiceManager();
		boFactory = (com.ibm.websphere.bo.BOFactory)serviceManager
		.locateService("com/ibm/websphere/bo/BOFactory");
	}

	/**
	 * Return a reference to the component service instance for this implementation
	 * class.  This method should be used when passing this service to a partner reference
	 * or if you want to invoke this component service asynchronously.    
	 *
	 * @generated (com.ibm.wbit.java)
	 */
	private Object getMyService() {
		return (Object) ServiceManager.INSTANCE.locateService("self");
	}

	/**
	 * Method generated to support implemention of operation "InputCriterion" defined for WSDL port type 
	 * named "CancelOrderandSendNotification".
	 * 
	 * The presence of commonj.sdo.DataObject as the return type and/or as a parameter 
	 * type conveys that its a complex type. Please refer to the WSDL Definition for more information 
	 * on the type of input, output and fault(s).
	 */
	public DataObject InputCriterion(DataObject Input)  {
		System.out.println("Cancel order invoked");
		// retrieve customer e-mail address
		DataObject customer = Input.getDataObject("Customer");
		String emailAddress = customer.getString("Email");

		// create e-mail text
		String text1 = "Shipment for order: " + Input.getInt("OrderNumber") + "\n";
		String text2 = "Dear " + customer.getString("ContactFirstName") + " " + customer.getString("ContactLastName") + "\n";
		String text3 = "We are sorry that your order was cancelled.\n";
		String text4 = "The amount of $" + Input.getDouble("TotalPrice") + " was too much at this time\n";
		String text5 = "We hope to serve you again in the future.\n";
		List orderitems = Input.getList("OrderItems");
		int nrofitems = orderitems.size();
		System.out.println("orderitems.size  = " + nrofitems);
		String itemtext[] = new String[nrofitems];
		String text6 = ""; 
		String text7 = "                                        "; //need this to ensure the product name has at least 40 chars
		for (int i=0; i<nrofitems; i++) {
			DataObject item = (DataObject)orderitems.get(i);
			String productName = (item.getString("ProductName") + text7).substring(0, 40);
			itemtext[i] = item.getInt("Quantity") + " " + item.getString("ProductNumber") + " " 
						+ productName + "  $" + new BigDecimal(item.getDouble("Price"));
			text6 = text6 + itemtext[i] + "\n";
		}
		String emailText = "\n" + text1 + text2 + text3 + text4 + text5 + text6;
		
		// build notification data object
		DataObject notification = boFactory.create(namespace, "Notification");
		notification.setString("email", emailAddress);
		notification.setString("text", emailText);
		System.out.println("Cancel order email address: " + emailAddress);
		System.out.println("Cancel order email text: " + emailText);
		
		return notification;
	}

}
