<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<!-- 
"This sample program is provided AS IS and may be used, executed, copied and modified without
royalty payment by customer (a) for its own instruction and study, (b) in order to develop 
applications designed to run with an IBM WebSphere product, either for customer's own 
internal use or for redistribution by customer, as part of such an application, in customer's own products."

Product 5655-FLW,  (C) COPYRIGHT International Business Machines Corp., 2009
All Rights Reserved * Licensed Materials - Property of IBM
-->
<HTML>
<HEAD>
<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
	pageEncoding="ISO-8859-1"%>
<META http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
<META name="GENERATOR" content="IBM Software Development Platform">
<META http-equiv="Content-Style-Type" content="text/css">
<LINK href="theme/Master.css" rel="stylesheet" type="text/css">
<TITLE>index.jsp</TITLE>
</HEAD>
<BODY>
<CENTER>
<H1>Query Tables Sample</H1>
<P><BR>
</P>
<p>Query your instance data using one of the predefined query tables</p> 
<hr width="100%" />
<H2>Select the query table:</H2>

<%!
  // aux functions
  // add escapes needed for HTML rendering
  private String addEscapes(String str) {
	return str.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
  }
  // add escapes needed for HTML rendering of Java strings: change " into \"
  private String addEscapes2(String str) {
	return addEscapes(str.replaceAll("\"", "\\\\\""));
  }
 %>

<%
  // List of predefined query tables as documented in
  //  http://publib.boulder.ibm.com/infocenter/dmndhelp/v6r2mx/topic/com.ibm.websphere.bpc.620.doc/doc/bpc/c6bpel_querytables_predef.html
  String predefinedTables[] = {
    "TASK",
    "PROCESS_INSTANCE",
    "ACTIVITY",
    "ACTIVITY_ATTRIBUTE",
    "ACTIVITY_SERVICE",
    "ESCALATION",
    "ESCALATION_CPROP",
    "ESCALATION_DESC",
    "PROCESS_ATTRIBUTE",
    "QUERY_PROPERTY",
    "TASK_CPROP",
    "TASK_DESC",
    "[OTHER]"
  };
  String qtName = ""; // for source code snippet below
  String other = request.getParameter("other");   // for pre-setting text field from URL parm
  if (other==null) {
      other = "";  // avoid NullPointerException
  }
  String sel = request.getParameter("selection"); // for pre-setting radio button from URL parm
  if (sel==null) {
      sel = "";  // avoid NullPointerException
  } else {
      qtName = sel; 
      if (sel.equals("[OTHER]")) {
      	   qtName = other;
      }
  }
  String attr = request.getParameter("attributes"); // for pre-setting text field from URL parm
  if (attr==null) {
      attr = "";  // avoid NullPointerException
  }
  String cond = request.getParameter("condition"); // for pre-setting text field from URL parm
  if (cond==null) {
      cond = "";  // avoid NullPointerException
  }
    
 %>
<FORM action="QueryServlet">
  <table>
<%
    // generate HTML code like this (for example, for query table name "TASK"):
    //    either
    // <tr><td><input type='radio' name='selection' value='TASK'> TASK</td></tr>
    //    or
    // <tr><td><input type='radio' name='selection' value='TASK' checked> TASK</td></tr>
    
    String nam;
    for (int i=0; i<predefinedTables.length-1; i++) {
        // for all regular table names (but not the last one "[OTHER]") 
        nam = predefinedTables[i];
    	out.println("<tr><td><input type='radio' "+
    	            "name='selection' value='" + nam + "'" +
    	            (sel.equals(nam)?" checked":"") +
    	            "> " + nam + "</td></tr>");
    }
    // now render the "[OTHER]" radio button with a text field 
    nam = predefinedTables[predefinedTables.length-1];
   	out.println("<tr><td><input type='radio' "+
    	            "name='selection' value='" + nam + "'" +
    	            (sel.equals(nam)?" checked":"") +
    	            "> " + nam + ": " + 
					"<input type='text' size='34' name='other'" +
					"value='" + addEscapes(other) + "'></td></tr>");
  %>
  </table>
  <table>
   <tr>
    <td align="right">Display the following columns, separated by comma:</td>
    <td><input type="text" size="50" name="attributes" value="<%=addEscapes(attr)%>"></td>
    <td>(leave empty to get ALL defined columns displayed)</td>
   </tr>
   <tr>
    <td align="right">Use the following query condition:</td>
    <td><input type="text" size="50" name="condition" value="<%=addEscapes(cond)%>"></td>
    <td>(leave empty to get ALL rows displayed)</td>
   </tr>
  </table>
  <input type="submit" name="Query" value="Submit query" ></FORM>
  <hr width="100%" />
	
<%
    // simple exception handling:
	if (request.getAttribute("exception") != null) {
 %>
			<BR>
			<H2>Exception occurred</H2>
			<CODE><%=request.getAttribute("exception")%></CODE>
<%
	} else
    // no query table specified so far 
	if (request.getAttribute("queryTable") == null) {
 %>
			<BR>
			<P>No query table selected for query.</P>
<%
	// query successful; extract and render results 
	} else {
		com.ibm.bpe.api.EntityResultSet ers = (com.ibm.bpe.api.EntityResultSet) request.getAttribute("result");
		if (ers != null) {
			com.ibm.bpe.api.EntityInfo ei = ers.getEntityInfo();
			java.util.List aiList = ei.getAttributeInfo();
 %>
			<BR>
			<H2>Current content of the query table <%=ers.getQueryTableName()%>:</H2>
			<% 		
			out.println("<table border='1'>");
			out.println("<tr>");
			for (int i = 0; i < aiList.size(); i++) {
				com.ibm.bpe.api.AttributeInfo ai = (com.ibm.bpe.api.AttributeInfo) aiList.get(i);
				out.println("<th>" + ai.getName() + "</th>");
			}
			out.println("</tr>");

			for (int i = 0; i < ers.getEntities().size(); i++) {
				com.ibm.bpe.api.Entity entity = (com.ibm.bpe.api.Entity) ers.getEntities().get(i);
				out.println("<tr>");
				for (int o = 0; o < aiList.size(); o++) {
					com.ibm.bpe.api.AttributeInfo ai = (com.ibm.bpe.api.AttributeInfo) aiList.get(o);
					out.println("<td>");
					if (entity.getAttributeValue(ai.getName()) != null) {
						if (! ai.isArray()) {
							if (ai.getType() == com.ibm.bpe.api.AttributeType.TIMESTAMP) {
								out.print(((java.util.Calendar) entity.getAttributeValue(ai.getName())).getTime());
							} else {
								out.print(entity.getAttributeValue(ai.getName()));
							}
						} else {
							out.print("<em>arrays not supported</em>");
						}
					} else {
							out.print("<em>n/a</em>");
					}
					out.println("</td>");
				}
				out.println("</tr>");
			}
			out.println("</table>");
 			// finally, render source code for the successful query	
 %>
	<hr width="100%" />
			
	<H2>Source code:</H2>
 	<TABLE>
 	  <tr><td>
		<CODE>
 		// java source code used for the query<BR/>
		BusinessFlowManagerService bfmService = getBFMService();<BR/>
		FilterOptions filterOpts = new FilterOptions();<BR/>
		filterOpts.setLocale(request.getLocale());<BR/>
		filterOpts.setThreshold(new Integer(20));<BR/>
		<%if (! attr.trim().equals("")) { %>
		    filterOpts.setSelectedAttributes("<%=addEscapes2(attr.trim())%>");<BR/>
		<% } %>
		<%if (! cond.trim().equals("")) { %>
		    filterOpts.setQueryCondition("<%=addEscapes2(cond.trim())%>");<BR/>
		<% } %>
		AdminAuthorizationOptions authOpts = null;<BR/>
		<%if (request.getRemoteUser().equals("admin")) { %>
		    authOpts = new AdminAuthorizationOptions();<BR/>
		<% } %>
		<b>EntityResultSet eRS = bfmService.queryEntities("<%=qtName.trim()%>", filterOpts, authOpts, null);</b><BR/>
        </CODE>
	  </td></tr>
	</TABLE>
<%
		}
 
	}
 %>
</CENTER>
</BODY>
</HTML>
